﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace VA.PPMS.Context
{
    [DataContract]
    public enum MapperAction
    {
        [EnumMember]
        Insert,
        [EnumMember]
        Update,
        [EnumMember]
        Delete
    }

    [DataContract]
    [KnownType(typeof(MapperAction))]
    [KnownType(typeof(Account))]
    public class MapperResultDetail
    {
        public string ProviderId => Provider != null ? Provider.GetAttributeValue<string>("ppms_providerid") : SchemaId;

        public bool IsValid => string.IsNullOrEmpty(ValidationMessage);

        public MapperResultDetail()
        {}

        public MapperResultDetail(string validationMessage)
        {
            ValidationMessage = validationMessage;
        }

        [DataMember]
        public MapperAction Action { get; set; }

        [DataMember]
        public string SchemaId { get; set; }

        [DataMember]
        public string ValidationMessage { get; set; }

        [DataMember]
        public Account Provider { get; set; }

        [DataMember]
        public IList<Entity> Entities { get; set; }

        [DataMember]
        public IList<SetStateRequest> Requests { get; set; }

        [DataMember]
        public string ValidationSource { get; set; }
    }
}